<?php
// verification_check.php
include '../config.php';
header('Content-Type: application/json');

// grab POST params
$user_id   = isset($_POST['user_id'])   ? intval($_POST['user_id'])   : 0;
$book_id   = isset($_POST['book_id'])   ? intval($_POST['book_id'])   : 0;

if (!$user_id || !$book_id) {
    echo json_encode(['success'=>false, 'message'=>'Missing user_id or book_id']);
    exit;
}

// 1) check one-off purchase
$sql = "SELECT id FROM purchased_books WHERE user_id = ? AND book_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $user_id, $book_id);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows > 0) {
    echo json_encode(['success'=>true, 'status'=>'owned']);
    exit;
}

// 2) check active subscription
$sql2 = "SELECT id FROM user_subscriptions 
         WHERE user_id = ? 
           AND start_date <= CURDATE() 
           AND end_date   >= CURDATE()";
$stmt2 = $conn->prepare($sql2);
$stmt2->bind_param("i", $user_id);
$stmt2->execute();
$stmt2->store_result();

if ($stmt2->num_rows > 0) {
    echo json_encode(['success'=>true, 'status'=>'subscribed']);
    exit;
}

// 3) neither
echo json_encode(['success'=>true, 'status'=>'none']);
