<?php
header('Content-Type: application/json');
include '../config.php';  // provides $conn

$userId = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
if ($userId <= 0) {
    echo json_encode(['success'=>false,'message'=>'Missing user_id']);
    exit;
}

$sql = "
  SELECT 
    us.id,
    us.start_date,
    us.end_date,
    s.name   AS package_name,
    s.amount AS package_price,
    s.period_days
  FROM user_subscriptions us
  JOIN subscriptions s ON us.subscription_id = s.id
  WHERE us.user_id = $userId
  ORDER BY us.start_date DESC
  LIMIT 1
";
$res = mysqli_query($conn, $sql);
if (!$res) {
    echo json_encode(['success'=>false,'message'=>mysqli_error($conn)]);
    exit;
}

if ($row = mysqli_fetch_assoc($res)) {
    echo json_encode([
      'success'      => true,
      'subscription' => $row
    ]);
} else {
    echo json_encode([
      'success' => true,
      'subscription' => null
    ]);
}
?>
