<?php
header('Content-Type: application/json');
include '../config.php';  // $conn

// Expect ?user_id= in query string
$userId = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
if ($userId <= 0) {
    echo json_encode(['success'=>false,'message'=>'Missing user_id']);
    exit;
}

$baseUrl = 'https://api.ngaizabooks.com/uploads';

$sql = "
  SELECT 
    pb.id               AS purchase_id,
    b.id                AS book_id,
    b.name              AS name,
    b.price             AS price,
    pb.purchase_date    AS purchase_date,
    b.cover_image,
    b.file_path
  FROM purchased_books pb
  JOIN books b ON pb.book_id = b.id
  WHERE pb.user_id = $userId
  ORDER BY pb.purchase_date DESC
";
$result = mysqli_query($conn, $sql);

$books = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        // full URL for cover and file
        $row['cover_image'] = "$baseUrl/covers/{$row['cover_image']}";
        $row['file_path']   = "$baseUrl/books/{$row['file_path']}";
        $books[] = $row;
    }
    echo json_encode(['success'=>true,'books'=>$books]);
} else {
    echo json_encode(['success'=>false,'message'=>mysqli_error($conn)]);
}
?>
