<?php
// manual_book_purchase.php
include '../config.php';
header('Content-Type: application/json');

// ensure DATETIME uses Dar es Salaam time
$conn->query("SET time_zone = '+03:00'");

// Read POST inputs
$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$book_id = isset($_POST['book_id']) ? intval($_POST['book_id']) : 0;
$phone   = isset($_POST['phone'])   ? trim($_POST['phone'])   : '';
$message = isset($_POST['message']) ? trim($_POST['message']) : '';

if (!$user_id || !$book_id || $phone === '' || $message === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Missing required fields.'
    ]);
    exit;
}

$sql = "INSERT INTO manual_book_purchases
        (user_id, book_id, phone, message, status, created_at)
        VALUES (?, ?, ?, ?, 0, NOW())";

if ($stmt = $conn->prepare($sql)) {
    $stmt->bind_param("iiss", $user_id, $book_id, $phone, $message);
    if ($stmt->execute()) {
        echo json_encode([
            'success'       => true,
            'purchase_id'   => $stmt->insert_id,
            'message'       => 'Manual book purchase recorded, awaiting confirmation.'
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Database error: ' . $stmt->error
        ]);
    }
    $stmt->close();
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Prepare failed: ' . $conn->error
    ]);
}

$conn->close();
