<?php
header('Content-Type: application/json');
include '../config.php';  // $conn

// Base URL kwa uploads (hakikisha ui-meongezea https://)
$baseUrl = 'https://api.ngaizabooks.com/uploads';

$sql = "SELECT id, name, price, cover_image, file_path FROM books";
$result = mysqli_query($conn, $sql);

$books = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        // Jadili njia kamili za cover na file
        // Ikiwa unahifadhi cover images katika subfolder "covers" ndani ya uploads:
        $row['cover_image'] = $baseUrl . '/covers/' . $row['cover_image'];
        // Ikiwa unahifadhi mafaili ya vitabu (PDF nk.) katika subfolder "books":
        $row['file_path']   = $baseUrl . '/books/' . $row['file_path'];

        $books[] = $row;
    }
    echo json_encode([
        'success' => true,
        'books'   => $books
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Database query failed: ' . mysqli_error($conn)
    ]);
}
