<?php
include '../../config.php';
header('Content-Type: application/json');

// Join user_subscriptions with users & subscriptions
$sql = "
  SELECT 
    us.id,
    us.user_id,
    CONCAT(u.first_name, ' ', u.last_name) AS user_name,
    u.phone             AS user_phone,
    us.subscription_id,
    s.name              AS subscription_name,
    s.amount            AS subscription_amount,
    s.period_days       AS subscription_period,
    us.start_date,
    us.end_date,
    us.created_at       AS subscribed_at
  FROM user_subscriptions us
  JOIN users u ON us.user_id = u.id
  JOIN subscriptions s ON us.subscription_id = s.id
  ORDER BY us.start_date DESC
";
$result = mysqli_query($conn, $sql);

$subs = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $subs[] = [
            'id'                     => (int)$row['id'],
            'user_name'              => $row['user_name'],
            'user_phone'             => $row['user_phone'],
            'subscription_name'      => $row['subscription_name'],
            'subscription_amount'    => (float)$row['subscription_amount'],
            'subscription_period'    => (int)$row['subscription_period'],
            'start_date'             => $row['start_date'],
            'end_date'               => $row['end_date'],
            'subscribed_at'          => $row['subscribed_at'],
        ];
    }
    echo json_encode(['success' => true, 'subscriptions' => $subs]);
} else {
    echo json_encode(['success' => false, 'message' => mysqli_error($conn)]);
}
?>
