<?php
include '../../config.php';

header('Content-Type: application/json');

// Total users (type = 0)
$usersQuery = mysqli_query($conn, "SELECT COUNT(*) AS total_users FROM users WHERE type = 0");
$totalUsers = mysqli_fetch_assoc($usersQuery)['total_users'];

// Total books
$booksQuery = mysqli_query($conn, "SELECT COUNT(*) AS total_books FROM books");
$totalBooks = mysqli_fetch_assoc($booksQuery)['total_books'];

// Total subscriptions
$totalSubsQuery = mysqli_query($conn, "SELECT COUNT(*) AS total_subscriptions FROM user_subscriptions");
$totalSubscriptions = mysqli_fetch_assoc($totalSubsQuery)['total_subscriptions'];

// Subscribed today
$today = date('Y-m-d');
$subsTodayQuery = mysqli_query($conn, "SELECT COUNT(*) AS subscribed_today FROM user_subscriptions WHERE DATE(created_at) = '$today'");
$subscribedToday = mysqli_fetch_assoc($subsTodayQuery)['subscribed_today'];

// Purchased books today
$purchasedTodayQuery = mysqli_query($conn, "SELECT COUNT(*) AS purchased_today FROM purchased_books WHERE DATE(purchase_date) = '$today'");
$purchasedToday = mysqli_fetch_assoc($purchasedTodayQuery)['purchased_today'];

// Amount subscribed today
$amountTodayQuery = mysqli_query($conn, "
    SELECT SUM(s.amount) AS total_amount_subscribed_today
    FROM user_subscriptions us
    JOIN subscriptions s ON us.subscription_id = s.id
    WHERE DATE(us.created_at) = '$today'
");
$amountSubscribedToday = mysqli_fetch_assoc($amountTodayQuery)['total_amount_subscribed_today'] ?? 0;

// Amount book purchased today
$amountBooksTodayQuery = mysqli_query($conn, "
    SELECT SUM(b.price) AS total_amount_books_today
    FROM purchased_books pb
    JOIN books b ON pb.book_id = b.id
    WHERE DATE(pb.purchase_date) = '$today'
");
$amountBooksToday = mysqli_fetch_assoc($amountBooksTodayQuery)['total_amount_books_today'] ?? 0;

// Week start (Monday)
$monday = date('Y-m-d', strtotime('monday this week'));

// Amount of subscriptions this week
$subsWeekQuery = mysqli_query($conn, "
    SELECT SUM(s.amount) AS amount_subscriptions_week
    FROM user_subscriptions us
    JOIN subscriptions s ON us.subscription_id = s.id
    WHERE DATE(us.created_at) >= '$monday'
");
$amountSubsWeek = mysqli_fetch_assoc($subsWeekQuery)['amount_subscriptions_week'] ?? 0;

// Amount of books purchased this week
$booksWeekQuery = mysqli_query($conn, "
    SELECT SUM(b.price) AS amount_books_week
    FROM purchased_books pb
    JOIN books b ON pb.book_id = b.id
    WHERE DATE(pb.purchase_date) >= '$monday'
");
$amountBooksWeek = mysqli_fetch_assoc($booksWeekQuery)['amount_books_week'] ?? 0;

echo json_encode([
    'success' => true,
    'data' => [
        'total_users' => (int)$totalUsers,
        'total_books' => (int)$totalBooks,
        'total_subscriptions' => (int)$totalSubscriptions,
        'subscribed_today' => (int)$subscribedToday,
        'purchased_today' => (int)$purchasedToday,
        'amount_subscribed_today' => (float)$amountSubscribedToday,
        'amount_books_today' => (float)$amountBooksToday,
        'amount_subscriptions_week' => (float)$amountSubsWeek,
        'amount_books_week' => (float)$amountBooksWeek,
    ]
]);
?>
