<?php
include '../../config.php';
header('Content-Type: application/json');

// Join purchased_books, users, books
$sql = "
  SELECT 
    pb.id AS purchase_id,
    CONCAT(u.first_name, ' ', u.last_name) AS user_name,
    u.phone        AS user_phone,
    b.name         AS book_name,
    b.price        AS book_price,
    pb.purchase_date
  FROM purchased_books pb
  JOIN users u   ON pb.user_id = u.id
  JOIN books b   ON pb.book_id = b.id
  ORDER BY pb.purchase_date DESC
";
$result = mysqli_query($conn, $sql);

$purchases = [];
if ($result) {
  while ($row = mysqli_fetch_assoc($result)) {
    $purchases[] = [
      'purchase_id'  => (int)$row['purchase_id'],
      'user_name'    => $row['user_name'],
      'user_phone'   => $row['user_phone'],
      'book_name'    => $row['book_name'],
      'book_price'   => (float)$row['book_price'],
      'purchase_date'=> $row['purchase_date'],
    ];
  }
  echo json_encode(['success'=>true, 'purchases'=>$purchases]);
} else {
  echo json_encode(['success'=>false, 'message'=>mysqli_error($conn)]);
}
?>
