<?php
include '../../config.php';

header('Content-Type: application/json');

// Fetch pending manual payments with user & subscription info
$sql = "
  SELECT 
    mp.id,
    mp.user_id,
    CONCAT(u.first_name, ' ', u.last_name) AS user_name,
    mp.subscription_id,
    s.name AS subscription_name,
    s.amount AS subscription_amount,
    mp.phone AS payment_phone,
    mp.message,
    mp.created_at
  FROM manual_payments mp
  JOIN users u ON mp.user_id = u.id
  JOIN subscriptions s ON mp.subscription_id = s.id
  WHERE mp.status = 0
  ORDER BY mp.created_at DESC
";
$result = mysqli_query($conn, $sql);

$payments = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $payments[] = [
            'id'                    => (int)$row['id'],
            'user_id'               => (int)$row['user_id'],
            'user_name'             => $row['user_name'],
            'subscription_id'       => (int)$row['subscription_id'],
            'subscription_name'     => $row['subscription_name'],
            'subscription_amount'   => (float)$row['subscription_amount'],
            'payment_phone'         => $row['payment_phone'],
            'message'               => $row['message'],
            'created_at'            => $row['created_at'],
        ];
    }
    echo json_encode([
        'success'  => true,
        'payments' => $payments,
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Database query failed: ' . mysqli_error($conn),
    ]);
}
?>
