<?php
include '../../config.php';
header('Content-Type: application/json');

// Fetch pending manual book purchases, joining user & book info
$sql = "
  SELECT
    mbp.id,
    mbp.user_id,
    CONCAT(u.first_name, ' ', u.last_name) AS user_name,
    mbp.book_id,
    b.name  AS book_name,
    b.price AS book_price,
    mbp.phone,
    mbp.message,
    mbp.created_at
  FROM manual_book_purchases mbp
  JOIN users u ON mbp.user_id = u.id
  JOIN books b ON mbp.book_id = b.id
  WHERE mbp.status = 0
  ORDER BY mbp.created_at DESC
";
$result = mysqli_query($conn, $sql);

$purchases = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $purchases[] = [
            'id'          => (int)$row['id'],
            'user_id'     => (int)$row['user_id'],
            'user_name'   => $row['user_name'],
            'book_id'     => (int)$row['book_id'],
            'book_name'   => $row['book_name'],
            'book_price'  => (float)$row['book_price'],
            'phone'       => $row['phone'],
            'message'     => $row['message'],
            'created_at'  => $row['created_at'],
        ];
    }
    echo json_encode([
        'success'   => true,
        'purchases' => $purchases,
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: '.mysqli_error($conn),
    ]);
}
?>
