<?php
include '../../config.php';
header('Content-Type: application/json');

// Ensure uploads dirs exist
$coverDir     = __DIR__ . '/../../uploads/covers/';
$documentDir  = __DIR__ . '/../../uploads/books/';
if (!is_dir($coverDir))    mkdir($coverDir, 0755, true);
if (!is_dir($documentDir)) mkdir($documentDir, 0755, true);

// Validate text inputs
$name  = $_POST['name']  ?? '';
$price = isset($_POST['price']) ? (float)$_POST['price'] : 0;
if ($name === '' || $price <= 0) {
    echo json_encode(['success'=>false,'message'=>'Invalid name or price']);
    exit;
}

// Validate files
if (!isset($_FILES['cover_image']) || !isset($_FILES['file_path'])) {
    echo json_encode(['success'=>false,'message'=>'Files missing']);
    exit;
}

// Handle cover image
$coverFile = $_FILES['cover_image'];
$coverName = time() . '_cover_' . basename($coverFile['name']);
$coverTarget = $coverDir . $coverName;
if (!move_uploaded_file($coverFile['tmp_name'], $coverTarget)) {
    echo json_encode(['success'=>false,'message'=>'Failed to upload cover']);
    exit;
}

// Handle document
$docFile = $_FILES['file_path'];
$docName = time() . '_doc_' . basename($docFile['name']);
$docTarget = $documentDir . $docName;
if (!move_uploaded_file($docFile['tmp_name'], $docTarget)) {
    echo json_encode(['success'=>false,'message'=>'Failed to upload document']);
    exit;
}

// Insert into database (store only filenames)
$sql = "INSERT INTO books (name, price, cover_image, file_path, created_at, updated_at)
        VALUES ('".mysqli_real_escape_string($conn,$name)."', $price,
                '$coverName', '$docName', NOW(), NOW())";
if (mysqli_query($conn, $sql)) {
    echo json_encode(['success'=>true,'message'=>'Book added']);
} else {
    echo json_encode(['success'=>false,'message'=>mysqli_error($conn)]);
}
?>
